import { nanoid } from 'nanoid'

// Generate CUID-like ID
export function generateId(): string {
  return nanoid()
}

// Helper to convert database rows to objects
export function rowToCustomer(row: {
  id: string
  name: string
  email: string | null
  phone: string | null
  company: string | null
  address: string | null
  notes: string | null
  createdAt: Date
  updatedAt: Date
}) {
  return {
    id: row.id,
    name: row.name,
    email: row.email,
    phone: row.phone,
    company: row.company,
    address: row.address,
    notes: row.notes,
    createdAt: row.createdAt,
    updatedAt: row.updatedAt,
  }
}

export function rowToUser(row: {
  id: string
  email: string
  name: string
  image: string | null
  createdAt: Date
  updatedAt: Date
}) {
  return {
    id: row.id,
    email: row.email,
    name: row.name,
    image: row.image,
    createdAt: row.createdAt,
    updatedAt: row.updatedAt,
  }
}

export function rowToTimeEntry(row: {
  id: string
  description: string
  startTime: Date
  endTime: Date
  duration: number
  createdAt: Date
  updatedAt: Date
  customerId: string
  userId: string
}) {
  return {
    id: row.id,
    description: row.description,
    startTime: row.startTime,
    endTime: row.endTime,
    duration: row.duration,
    createdAt: row.createdAt,
    updatedAt: row.updatedAt,
    customerId: row.customerId,
    userId: row.userId,
  }
}

