import { NextResponse } from "next/server"
import { prisma } from "@/lib/prisma"

export async function GET() {
  try {
    // Test Prisma connection
    await prisma.$connect()
    const customerCount = await prisma.customer.count()
    
    return NextResponse.json({ 
      success: true,
      message: "Prisma connection successful",
      customerCount 
    })
  } catch (error: unknown) {
    console.error("Test error:", error)
    const errorMessage = error instanceof Error ? error.message : "Unknown error"
    const errorStack = process.env.NODE_ENV === 'development' && error instanceof Error ? error.stack : undefined
    return NextResponse.json({ 
      success: false,
      error: errorMessage,
      stack: errorStack
    }, { status: 500 })
  }
}

