"use client"

import { Logo } from "@/components/Logo"
import { ThemeToggle } from "@/components/theme-toggle"
import { Button } from "@/components/ui/button"
import Link from "next/link"
import { Clock, User } from "lucide-react"

export default function Dashboard() {
  return (
    <div className="min-h-screen bg-background">
      {/* Header */}
      <header className="border-b bg-card">
        <div className="container mx-auto flex h-16 items-center justify-between px-4">
          <Logo className="h-8" />
          <div className="flex items-center gap-4">
            <span className="text-sm text-muted-foreground">Mitarbeiter Dashboard</span>
            <ThemeToggle />
          </div>
        </div>
      </header>

      {/* Main Content */}
      <main className="container mx-auto px-4 py-8">
        <div className="mb-8">
          <h1 className="text-3xl font-bold">Willkommen im Dashboard</h1>
          <p className="text-muted-foreground mt-2">
            Übersicht und Verwaltung für CoreX Management Mitarbeiter
          </p>
        </div>

        {/* Navigation to Modules */}
        <div className="grid gap-4 md:grid-cols-2 lg:grid-cols-3">
          <Link href="/zeiterfassung">
            <div className="p-6 border rounded-lg hover:bg-accent/50 transition-colors cursor-pointer">
              <div className="flex items-center gap-3 mb-2">
                <Clock className="h-6 w-6" />
                <h2 className="text-xl font-semibold">Zeiterfassung</h2>
              </div>
              <p className="text-sm text-muted-foreground">
                Arbeitszeit erfassen und verwalten
              </p>
            </div>
          </Link>
          <Link href="/kunden">
            <div className="p-6 border rounded-lg hover:bg-accent/50 transition-colors cursor-pointer">
              <div className="flex items-center gap-3 mb-2">
                <User className="h-6 w-6" />
                <h2 className="text-xl font-semibold">Kunden</h2>
              </div>
              <p className="text-sm text-muted-foreground">
                Kunden verwalten und Kontaktdaten pflegen
              </p>
            </div>
          </Link>
        </div>
      </main>
    </div>
  )
}

