import { NextResponse } from "next/server"
import { prisma } from "@/lib/prisma"

export async function GET() {
  try {
    // Test Prisma connection
    await prisma.$connect()
    const customerCount = await prisma.customer.count()
    
    return NextResponse.json({ 
      success: true,
      message: "Prisma connection successful",
      customerCount 
    })
  } catch (error: any) {
    console.error("Test error:", error)
    return NextResponse.json({ 
      success: false,
      error: error?.message || "Unknown error",
      stack: process.env.NODE_ENV === 'development' ? error?.stack : undefined
    }, { status: 500 })
  }
}

