# CoreX Management Dashboard

Internes Dashboard für CoreX Management Mitarbeiter mit Zeiterfassung und Kundenverwaltung.

## Features

- ✅ **Zeiterfassung**: Timer-basierte und manuelle Zeiterfassung
- ✅ **Kundenverwaltung**: Vollständige CRUD-Funktionalität für Kunden
- ✅ **Datenbank**: SQLite mit Prisma ORM
- ✅ **Dark Mode**: Unterstützung für Light/Dark Theme
- ✅ **Filter & Sortierung**: Erweiterte Filter- und Sortierfunktionen

## Tech Stack

- **Framework**: Next.js 16.1.1 (App Router)
- **Language**: TypeScript
- **Styling**: Tailwind CSS v4
- **Database**: SQLite mit Prisma ORM
- **UI Components**: Radix UI, Lucide Icons

## Getting Started

### Voraussetzungen

- Node.js 20 oder höher
- npm oder yarn

### Installation

1. Repository klonen:
```bash
git clone https://gitlab.corexmanagement.de/HendrikGarske/web-corex.git
cd web-corex
```

2. Dependencies installieren:
```bash
npm install
```

3. Umgebungsvariablen einrichten:
Erstellen Sie eine `.env` Datei im Root-Verzeichnis:
```env
DATABASE_URL="file:./dev.db"
```

4. Datenbank initialisieren:
```bash
npx prisma generate
npx prisma migrate dev
```

5. Development Server starten:
```bash
npm run dev
```

Die Anwendung läuft dann auf [http://localhost:3000](http://localhost:3000)

## Projektstruktur

```
├── app/
│   ├── api/              # API Routes
│   │   ├── customers/    # Kunden-API
│   │   ├── time-entries/ # Zeiterfassungs-API
│   │   └── users/        # Benutzer-API
│   ├── kunden/           # Kunden-Verwaltungsseiten
│   ├── zeiterfassung/    # Zeiterfassungsseite
│   └── page.tsx          # Dashboard-Hauptseite
├── components/           # React Komponenten
│   ├── ui/              # UI-Komponenten (Button, Card, Input, etc.)
│   └── ...
├── lib/                 # Utility-Funktionen
│   ├── prisma.ts        # Prisma Client
│   └── utils.ts         # Helper-Funktionen
└── prisma/              # Datenbank-Schema und Migrations
    └── schema.prisma
```

## Scripts

- `npm run dev` - Development Server starten
- `npm run build` - Production Build erstellen
- `npm run start` - Production Server starten
- `npm run lint` - ESLint ausführen
- `npx prisma studio` - Prisma Studio öffnen (Datenbank-Viewer)

## Datenbank

Das Projekt verwendet Prisma ORM mit SQLite. Die Datenbank-Schema-Definitionen befinden sich in `prisma/schema.prisma`.

### Migrationen

Neue Migrationen erstellen:
```bash
npx prisma migrate dev --name migration_name
```

Datenbank zurücksetzen (⚠️ löscht alle Daten):
```bash
npx prisma migrate reset
```

## Entwicklung

### Neue Module hinzufügen

1. Erstellen Sie eine neue Seite in `app/[modul-name]/page.tsx`
2. Fügen Sie API-Routen in `app/api/[modul-name]/route.ts` hinzu
3. Aktualisieren Sie das Dashboard in `app/page.tsx` mit einem Link zum neuen Modul

### Authentifizierung

Die Authentifizierung/SSO ist noch nicht implementiert. Die Middleware-Struktur ist in `middleware.ts` vorbereitet.

## License

Proprietär - CoreX Management
