import { NextResponse } from "next/server"
import { initDatabase } from "@/lib/db"

export async function GET() {
  try {
    await initDatabase()
    return NextResponse.json({ success: true, message: "Database initialized" })
  } catch (error) {
    console.error("Error initializing database:", error)
    const errorMessage = error instanceof Error ? error.message : String(error)
    return NextResponse.json(
      { success: false, error: errorMessage },
      { status: 500 }
    )
  }
}

