# CoreX Management Dashboard

> Internes Management-Dashboard für CoreX Management mit Zeiterfassung und Kundenverwaltung

⚠️ **Privates Repository** - Nur für interne Nutzung durch CoreX Management Mitarbeiter.

[![Next.js](https://img.shields.io/badge/Next.js-16.1.1-black)](https://nextjs.org/)
[![TypeScript](https://img.shields.io/badge/TypeScript-5.0-blue)](https://www.typescriptlang.org/)
[![Prisma](https://img.shields.io/badge/Prisma-6.19-2D3748)](https://www.prisma.io/)
[![PostgreSQL](https://img.shields.io/badge/PostgreSQL-Latest-336791)](https://www.postgresql.org/)
[![Docker](https://img.shields.io/badge/Docker-Ready-2496ED)](https://www.docker.com/)

## 📋 Inhaltsverzeichnis

- [Überblick](#überblick)
- [Features](#features)
- [Tech Stack](#tech-stack)
- [Voraussetzungen](#voraussetzungen)
- [Installation](#installation)
- [Konfiguration](#konfiguration)
- [Datenbank Setup](#datenbank-setup)
- [Entwicklung](#entwicklung)
- [Projektstruktur](#projektstruktur)
- [API Dokumentation](#api-dokumentation)
- [Deployment](#deployment)
- [Mitwirken](#mitwirken)

## 🎯 Überblick

Das CoreX Management Dashboard ist eine interne Webanwendung zur Verwaltung von Arbeitszeiten und Kundenbeziehungen. Es bietet Mitarbeitern eine intuitive Oberfläche zur Zeiterfassung und umfassende Funktionen zur Kundenverwaltung.

## ✨ Features

### Zeiterfassung
- ⏱️ **Timer-Funktionalität**: Start/Stop/Pause/Weiter
- 📝 **Manuelle Zeiterfassung**: Direktes Eintragen von Stunden
- 👥 **Kunden-Zuordnung**: Jeder Zeiteintrag wird einem Kunden zugeordnet
- 📊 **Filter & Sortierung**: Nach Datum, Kunde, Dauer oder Beschreibung
- 📈 **Übersicht**: Gesamtstunden und detaillierte Statistiken

### Kundenverwaltung
- ➕ **CRUD-Operationen**: Vollständige Verwaltung von Kundendaten
- 📧 **Kontaktdaten**: E-Mail, Telefon, Adresse, Unternehmen
- 📝 **Notizen**: Freitext-Notizen zu jedem Kunden
- 🔍 **Suche**: Schnelle Suche nach Name, E-Mail, Unternehmen oder Telefon
- 📊 **Zeitübersicht**: Anzeige aller Zeiteinträge pro Kunde mit Statistiken

### Weitere Features
- 🌓 **Dark Mode**: Automatischer Dark/Light Mode mit Theme-Toggle
- 📱 **Responsive Design**: Optimiert für Desktop, Tablet und Mobile
- 🔒 **Sicherheit**: Vorbereitet für SSO-Authentifizierung
- ⚡ **Performance**: Optimiert mit Next.js App Router

## 🛠 Tech Stack

- **Framework**: [Next.js 16.1.1](https://nextjs.org/) (App Router)
- **Sprache**: [TypeScript 5.0](https://www.typescriptlang.org/)
- **Styling**: [Tailwind CSS v4](https://tailwindcss.com/)
- **Datenbank**: [PostgreSQL](https://www.postgresql.org/)
- **ORM**: [Prisma 6.19](https://www.prisma.io/)
- **UI Components**: 
  - [Radix UI](https://www.radix-ui.com/)
  - [Lucide Icons](https://lucide.dev/)
- **State Management**: React Hooks
- **Theme**: [next-themes](https://github.com/pacocoursey/next-themes)

## 📦 Voraussetzungen

- **Linux** (Ubuntu/Debian empfohlen) oder Docker
- **Node.js**: Version 20 oder höher
- **PostgreSQL**: Version 12 oder höher
- **npm** oder **yarn** oder **pnpm**
- **Git** (für Clone)
- **Docker & Docker Compose** (optional, für Container-basiertes Setup)

## 🚀 Installation

### 1. Repository klonen

> ⚠️ **Zugriff erforderlich**: Stellen Sie sicher, dass Sie Zugriff auf das private GitLab-Repository haben.

```bash
git clone https://gitlab.corexmanagement.de/HendrikGarske/web-corex.git
cd web-corex
```

### 2. Dependencies installieren

```bash
npm install
# oder
yarn install
# oder
pnpm install
```

### 3. Umgebungsvariablen konfigurieren

Erstellen Sie eine `.env` Datei im Root-Verzeichnis:

```bash
cp .env.example .env  # Falls vorhanden
# oder manuell erstellen
```

Fügen Sie folgende Variablen hinzu:

```env
DATABASE_URL="postgresql://username:password@localhost:5432/corex_dashboard?schema=public"
```

### 4. Datenbank Setup

Siehe [Datenbank Setup](#datenbank-setup) für detaillierte Anweisungen.

### 5. Datenbank initialisieren

```bash
# Prisma Client generieren
npx prisma generate

# Migrationen ausführen
npx prisma migrate dev
```

### 6. Development Server starten

```bash
npm run dev
```

Die Anwendung läuft jetzt auf [http://localhost:3000](http://localhost:3000)

## ⚙️ Konfiguration

### Umgebungsvariablen

| Variable | Beschreibung | Beispiel |
|----------|--------------|----------|
| `DATABASE_URL` | PostgreSQL Verbindungs-URL | `postgresql://user:pass@localhost:5432/dbname` |

### Datenbank-URL Format

```
postgresql://[user]:[password]@[host]:[port]/[database]?schema=public
```

## 🗄️ Datenbank Setup

### PostgreSQL Installation (Linux)

#### Ubuntu/Debian
```bash
sudo apt-get update
sudo apt-get install postgresql postgresql-contrib
sudo systemctl start postgresql
sudo systemctl enable postgresql
```

#### Docker (Empfohlen)
```bash
# PostgreSQL Container starten
docker run --name corex-postgres \
  -e POSTGRES_USER=corex_user \
  -e POSTGRES_PASSWORD=ihr_sicheres_passwort \
  -e POSTGRES_DB=corex_dashboard \
  -p 5432:5432 \
  -d postgres:15
```

Oder mit Docker Compose (siehe `docker-compose.yml` unten).

### Datenbank erstellen

1. **PostgreSQL Terminal öffnen**:
```bash
psql -U postgres
```

2. **Datenbank erstellen**:
```sql
CREATE DATABASE corex_dashboard;
```

3. **(Optional) Benutzer erstellen** (empfohlen für Produktion):
```sql
CREATE USER corex_user WITH PASSWORD 'ihr_sicheres_passwort';
GRANT ALL PRIVILEGES ON DATABASE corex_dashboard TO corex_user;
\q
```

4. **DATABASE_URL in .env aktualisieren**:
```env
DATABASE_URL="postgresql://corex_user:ihr_sicheres_passwort@localhost:5432/corex_dashboard?schema=public"
```

### Migrationen ausführen

```bash
# Initiale Migration
npx prisma migrate dev --name init

# Weitere Migrationen (nach Schema-Änderungen)
npx prisma migrate dev --name beschreibung_der_aenderung
```

### Prisma Studio (Datenbank-Viewer)

```bash
npx prisma studio
```

Öffnet einen Browser-basierten Datenbank-Viewer auf [http://localhost:5555](http://localhost:5555)

## 💻 Entwicklung

### Verfügbare Scripts

```bash
# Development Server starten
npm run dev

# Production Build erstellen
npm run build

# Production Server starten
npm run start

# ESLint ausführen
npm run lint

# Prisma Client generieren
npx prisma generate

# Neue Migration erstellen
npx prisma migrate dev --name migration_name

# Datenbank zurücksetzen (⚠️ löscht alle Daten)
npx prisma migrate reset

# Prisma Studio öffnen
npx prisma studio
```

### Entwicklungsworkflow

1. **Feature-Branch erstellen**:
```bash
git checkout -b feature/mein-feature
```

2. **Änderungen machen und committen**:
```bash
git add .
git commit -m "feat: Beschreibung des Features"
```

3. **Push und Merge Request erstellen**:
```bash
git push origin feature/mein-feature
```

4. **Nach Merge: Branch löschen**:
```bash
git checkout main
git pull
git branch -d feature/mein-feature
```

### Code-Stil

- TypeScript strict mode aktiviert
- ESLint für Code-Qualität
- Prettier (empfohlen) für Code-Formatierung

## 📁 Projektstruktur

```
corex-dashboard/
├── app/                        # Next.js App Router
│   ├── api/                   # API Routes
│   │   ├── customers/         # Kunden-API
│   │   ├── time-entries/      # Zeiterfassungs-API
│   │   └── users/             # Benutzer-API
│   ├── kunden/                # Kunden-Verwaltungsseiten
│   │   └── [id]/              # Kunden-Detailseite
│   ├── zeiterfassung/         # Zeiterfassungsseite
│   ├── layout.tsx             # Root Layout
│   ├── page.tsx               # Dashboard-Hauptseite
│   └── globals.css            # Globale Styles
├── components/                # React Komponenten
│   ├── ui/                   # Wiederverwendbare UI-Komponenten
│   │   ├── button.tsx
│   │   ├── card.tsx
│   │   ├── input.tsx
│   │   ├── label.tsx
│   │   ├── select.tsx
│   │   └── textarea.tsx
│   ├── Logo.tsx              # Logo-Komponente
│   ├── theme-provider.tsx    # Theme-Provider
│   └── theme-toggle.tsx      # Theme-Toggle Button
├── lib/                       # Utility-Funktionen
│   ├── prisma.ts             # Prisma Client Singleton
│   └── utils.ts              # Helper-Funktionen (cn, etc.)
├── prisma/                    # Prisma Konfiguration
│   ├── migrations/           # Datenbank-Migrationen
│   └── schema.prisma         # Datenbank-Schema
├── public/                    # Statische Assets
│   ├── branding/             # Logo-Varianten
│   └── logo.png              # Hauptlogo
├── .gitignore
├── .gitlab-ci.yml            # GitLab CI/CD Konfiguration
├── next.config.ts            # Next.js Konfiguration
├── package.json
├── tsconfig.json             # TypeScript Konfiguration
└── README.md
```

## 🔌 API Dokumentation

### Kunden API

#### GET `/api/customers`
Liste aller Kunden abrufen

**Query Parameter:**
- `search` (optional): Suchbegriff für Name, E-Mail oder Unternehmen

**Response:**
```json
[
  {
    "id": "string",
    "name": "string",
    "email": "string | null",
    "phone": "string | null",
    "company": "string | null",
    "address": "string | null",
    "notes": "string | null",
    "createdAt": "ISO-Date",
    "updatedAt": "ISO-Date",
    "timeEntries": [...]
  }
]
```

#### POST `/api/customers`
Neuen Kunden erstellen

**Body:**
```json
{
  "name": "string (required)",
  "email": "string (optional)",
  "phone": "string (optional)",
  "company": "string (optional)",
  "address": "string (optional)",
  "notes": "string (optional)"
}
```

#### GET `/api/customers/[id]`
Kunde nach ID abrufen

#### PUT `/api/customers/[id]`
Kunde aktualisieren

#### DELETE `/api/customers/[id]`
Kunde löschen

### Zeiterfassungs API

#### GET `/api/time-entries`
Zeiteinträge abrufen

**Query Parameter:**
- `customerId` (optional): Filter nach Kunden-ID
- `userId` (optional): Filter nach Benutzer-ID

#### POST `/api/time-entries`
Neuen Zeiteintrag erstellen

**Body:**
```json
{
  "description": "string (required)",
  "startTime": "ISO-Date (required)",
  "endTime": "ISO-Date (required)",
  "duration": "number (required, in seconds)",
  "customerId": "string (required)",
  "userId": "string (required)"
}
```

#### DELETE `/api/time-entries/[id]`
Zeiteintrag löschen

## 🐳 Docker Setup

### Docker Compose (Empfohlen)

Erstellen Sie eine `docker-compose.yml` Datei:

```yaml
version: '3.8'

services:
  postgres:
    image: postgres:15
    container_name: corex-postgres
    environment:
      POSTGRES_USER: corex_user
      POSTGRES_PASSWORD: ${POSTGRES_PASSWORD}
      POSTGRES_DB: corex_dashboard
    ports:
      - "5432:5432"
    volumes:
      - postgres_data:/var/lib/postgresql/data
    restart: unless-stopped

  app:
    build: .
    container_name: corex-dashboard
    ports:
      - "3000:3000"
    environment:
      DATABASE_URL: postgresql://corex_user:${POSTGRES_PASSWORD}@postgres:5432/corex_dashboard?schema=public
      NODE_ENV: production
    depends_on:
      - postgres
    restart: unless-stopped

volumes:
  postgres_data:
```

**Start mit Docker Compose:**

```bash
# .env Datei erstellen
echo "POSTGRES_PASSWORD=ihr_sicheres_passwort" > .env

# Services starten
docker-compose up -d

# Logs anzeigen
docker-compose logs -f

# Services stoppen
docker-compose down
```

### Dockerfile

Erstellen Sie eine `Dockerfile`:

```dockerfile
FROM node:20-alpine AS base

# Install dependencies only when needed
FROM base AS deps
RUN apk add --no-cache libc6-compat
WORKDIR /app
COPY package.json package-lock.json ./
RUN npm ci

# Rebuild the source code only when needed
FROM base AS builder
WORKDIR /app
COPY --from=deps /app/node_modules ./node_modules
COPY . .
RUN npx prisma generate
RUN npm run build

# Production image, copy all the files and run next
FROM base AS runner
WORKDIR /app

ENV NODE_ENV production

RUN addgroup --system --gid 1001 nodejs
RUN adduser --system --uid 1001 nextjs

COPY --from=builder /app/public ./public
COPY --from=builder --chown=nextjs:nodejs /app/.next/standalone ./
COPY --from=builder --chown=nextjs:nodejs /app/.next/static ./.next/static

USER nextjs

EXPOSE 3000

ENV PORT 3000
ENV HOSTNAME "0.0.0.0"

CMD ["node", "server.js"]
```

## 🚢 Deployment

### GitLab CI/CD

Das Projekt verwendet GitLab CI/CD für automatische Builds und Tests.

**Pipeline Stages:**
1. **Build**: Kompiliert TypeScript, generiert Prisma Client
2. **Test**: Führt ESLint aus

> ⚠️ **Privates Repository**: CI/CD ist nur für autorisierte GitLab-Nutzer verfügbar.

### Umgebungsvariablen für Deployment

Stellen Sie sicher, dass folgende Variablen in Ihrer Deployment-Umgebung gesetzt sind:

- `DATABASE_URL`: PostgreSQL Verbindungs-URL
- `NODE_ENV`: `production` für Produktion

### Build für Produktion

```bash
npm run build
npm run start
```

## 🔐 Authentifizierung

Die Authentifizierung/SSO ist aktuell noch nicht implementiert. Die Middleware-Struktur ist in `middleware.ts` vorbereitet.

**Geplante Implementierung:**
- SSO-Integration (z.B. OAuth2, SAML)
- Session-Management
- Rollenbasierte Zugriffskontrolle

## 🤝 Mitwirken

### Pull Request Prozess

1. Feature-Branch erstellen
2. Änderungen implementieren
3. Tests ausführen (`npm run lint`, `npm run build`)
4. Merge Request in GitLab erstellen
5. Code Review abwarten
6. Nach Merge: Branch löschen

### Commit-Messages

Verwenden Sie konventionelle Commit-Messages:

- `feat:` Neue Funktion
- `fix:` Bug-Fix
- `docs:` Dokumentation
- `style:` Code-Formatierung
- `refactor:` Code-Refactoring
- `test:` Tests hinzufügen/ändern
- `chore:` Build-Prozess, Dependencies

## 📝 Lizenz

**Proprietär - CoreX Management**

Dieses Repository ist **privat** und nur für interne Nutzung durch autorisierte CoreX Management Mitarbeiter bestimmt. Jegliche Verbreitung oder Weitergabe des Codes ist untersagt.

## 🔒 Sicherheit

- Private GitLab-Repository (kein öffentlicher Zugriff)
- Zugriff nur für autorisierte Mitarbeiter
- Sensitive Daten (Passwörter, Keys) niemals committen
- `.env` Dateien sind in `.gitignore` enthalten

## 👥 Kontakt

Bei Fragen oder Problemen wenden Sie sich bitte an das interne Entwicklungsteam.

---

**Version**: 0.1.0  
**Letzte Aktualisierung**: Dezember 2024  
**Repository**: Privat - GitLab CoreX Management
