import { NextResponse } from "next/server"
import { wgApi } from "@/lib/wg-api"

export async function GET() {
  try {
    const stats = await wgApi.getStats()
    return NextResponse.json(stats)
  } catch (error) {
    console.error("Error fetching stats:", error)
    const errorMessage = error instanceof Error ? error.message : "Failed to fetch stats"
    return NextResponse.json(
      { error: errorMessage },
      { status: 500 }
    )
  }
}

