# WG Easy - WireGuard VPN Management

> WireGuard VPN Management Interface mit CoreX Design

⚠️ **Privates Repository** - Nur für interne Nutzung.

[![Next.js](https://img.shields.io/badge/Next.js-16.1.1-black)](https://nextjs.org/)
[![TypeScript](https://img.shields.io/badge/TypeScript-5.0-blue)](https://www.typescriptlang.org/)
[![Docker](https://img.shields.io/badge/Docker-Ready-2496ED)](https://www.docker.com/)

## 🎯 Überblick

WG Easy ist eine moderne Webanwendung zur Verwaltung von WireGuard VPN-Servern und -Clients.

## ✨ Features

- 🔐 **Client-Verwaltung**: Erstellen, löschen und verwalten Sie VPN-Clients
- 📊 **Dashboard**: Übersicht über aktive Verbindungen und Traffic
- 📥 **Konfigurations-Download**: WireGuard .conf Dateien herunterladen
- 📱 **QR-Code**: QR-Codes für einfache Client-Einrichtung
- 🔌 **Client-Aktivierung**: Clients aktivieren/deaktivieren
- 📈 **Live-Statistiken**: Echtzeit-Traffic-Statistiken
- 🎨 **Modernes Design**: CoreX Design System
- 🌓 **Dark Mode**: Automatischer Dark/Light Mode
- 📱 **Responsive**: Optimiert für alle Geräte

## 🛠 Tech Stack

- **Framework**: [Next.js 16.1.1](https://nextjs.org/) (App Router)
- **Sprache**: [TypeScript 5.0](https://www.typescriptlang.org/)
- **Styling**: [Tailwind CSS v4](https://tailwindcss.com/)
- **UI Components**: 
  - [Radix UI](https://www.radix-ui.com/)
  - [Lucide Icons](https://lucide.dev/)
- **Theme**: [next-themes](https://github.com/pacocoursey/next-themes)

## 📦 Voraussetzungen

- **Linux** (Ubuntu/Debian empfohlen) oder Docker
- **Node.js**: Version 20 oder höher
- **npm** oder **yarn** oder **pnpm**
- **Git** (für Clone)
- **Docker & Docker Compose** (optional)
- **wg-easy Backend**: WireGuard Easy Docker Container (siehe Setup unten)

## 🚀 Installation

### 1. Repository klonen

```bash
git clone <repository-url>
cd wg-easy
```

### 2. Dependencies installieren

```bash
npm install
```

### 3. WireGuard Easy Backend starten

```bash
docker run -d \
  --name=wg-easy \
  -e WG_HOST=YOUR_SERVER_IP \
  -e PASSWORD=YOUR_PASSWORD \
  -v ~/.wg-easy:/etc/wireguard \
  -p 51820:51820/udp \
  -p 51821:51821/tcp \
  --cap-add=NET_ADMIN \
  --cap-add=SYS_MODULE \
  --sysctl="net.ipv4.conf.all.src_valid_mark=1" \
  --sysctl="net.ipv4.ip_forward=1" \
  --restart unless-stopped \
  weejewel/wg-easy
```

### 4. Umgebungsvariablen konfigurieren

Eine `.env.local` Datei ist bereits vorhanden mit den Standardwerten.

**Aktuelle Konfiguration:**
- `WG_API_URL`: `https://corex-wg-easy.corexmanagement.de`
- `WG_PASSWORD`: Automatisch generiert (in .env.local)

**Für lokale Entwicklung:**
Sie können die `.env.local` Datei bearbeiten, um andere Werte zu verwenden.

### 5. Development Server starten

```bash
npm run dev
```

Die Anwendung läuft jetzt auf [http://localhost:3000](http://localhost:3000)

## 🐳 Docker Setup

### Dockerfile

Das Projekt enthält ein optimiertes Multi-Stage Dockerfile für Production-Builds.

### Build & Run

```bash
# Build
docker build -t wg-easy .

# Run
docker run -p 3000:3000 wg-easy
```

## 🚢 Deployment

### GitLab CI/CD

Das Projekt verwendet GitLab CI/CD für automatische Builds und Tests.

**Pipeline Stages:**
1. **Build**: Kompiliert TypeScript und erstellt Production Build
2. **Test**: Führt ESLint aus

### CapRover

Das Projekt enthält eine `captain-definition` Datei für CapRover Deployment.

## 📝 Scripts

- `npm run dev` - Development Server starten
- `npm run build` - Production Build erstellen
- `npm run start` - Production Server starten
- `npm run lint` - ESLint ausführen

## 📝 Lizenz

**Proprietär**

Dieses Repository ist **privat** und nur für interne Nutzung bestimmt.

---

**Version**: 0.1.0  
**Letzte Aktualisierung**: Dezember 2024

