# WG Easy - WireGuard VPN Management

> WireGuard VPN Management Interface mit CoreX Design

⚠️ **Privates Repository** - Nur für interne Nutzung.

[![Next.js](https://img.shields.io/badge/Next.js-16.1.1-black)](https://nextjs.org/)
[![TypeScript](https://img.shields.io/badge/TypeScript-5.0-blue)](https://www.typescriptlang.org/)
[![Docker](https://img.shields.io/badge/Docker-Ready-2496ED)](https://www.docker.com/)

## 🎯 Überblick

WG Easy ist eine moderne Webanwendung zur Verwaltung von WireGuard VPN-Servern und -Clients.

## ✨ Features

- 🔐 **Client-Verwaltung**: Erstellen, löschen und verwalten Sie VPN-Clients
- 📊 **Dashboard**: Übersicht über aktive Verbindungen und Traffic
- 📥 **Konfigurations-Download**: WireGuard .conf Dateien herunterladen
- 📱 **QR-Code**: QR-Codes für einfache Client-Einrichtung
- 🔌 **Client-Aktivierung**: Clients aktivieren/deaktivieren
- 📈 **Live-Statistiken**: Echtzeit-Traffic-Statistiken
- 🎨 **Modernes Design**: CoreX Design System
- 🌓 **Dark Mode**: Automatischer Dark/Light Mode
- 📱 **Responsive**: Optimiert für alle Geräte

## 🛠 Tech Stack

- **Framework**: [Next.js 16.1.1](https://nextjs.org/) (App Router)
- **Sprache**: [TypeScript 5.0](https://www.typescriptlang.org/)
- **Styling**: [Tailwind CSS v4](https://tailwindcss.com/)
- **UI Components**: 
  - [Radix UI](https://www.radix-ui.com/)
  - [Lucide Icons](https://lucide.dev/)
- **Theme**: [next-themes](https://github.com/pacocoursey/next-themes)

## 📦 Voraussetzungen

- **Linux** (Ubuntu/Debian empfohlen) oder Docker
- **Node.js**: Version 20 oder höher
- **npm** oder **yarn** oder **pnpm**
- **Git** (für Clone)
- **Docker & Docker Compose** (optional)
- **wg-easy Backend**: WireGuard Easy Docker Container (siehe Setup unten)

## 🚀 Installation

### 1. Repository klonen

```bash
git clone <repository-url>
cd wg-easy
```

### 2. Dependencies installieren

```bash
npm install
```

### 3. Development Server starten

```bash
npm run dev
```

Die Anwendung läuft jetzt auf [http://localhost:3000](http://localhost:3000)

**Wichtig:** Die Anwendung ist bereits vollständig konfiguriert mit:
- **WG_API_URL**: `https://corex-wg-easy.corexmanagement.de`
- **WG_PASSWORD**: `CoreX2024!Secure#VPN`

**Keine .env Datei erforderlich!** Die Standardwerte sind direkt im Code konfiguriert.

## 🐳 Docker Setup

### Dockerfile

Das Projekt enthält ein optimiertes Multi-Stage Dockerfile für Production-Builds.

### Build & Run

```bash
# Build
docker build -t wg-easy .

# Run
docker run -p 3000:3000 wg-easy
```

## 🚢 Deployment

### GitLab CI/CD

Das Projekt verwendet GitLab CI/CD für automatische Builds und Tests.

**Pipeline Stages:**
1. **Build**: Kompiliert TypeScript und erstellt Production Build
2. **Test**: Führt ESLint aus

### CapRover

Das Projekt enthält eine `captain-definition` Datei für CapRover Deployment.

## 📝 Scripts

- `npm run dev` - Development Server starten
- `npm run build` - Production Build erstellen
- `npm run start` - Production Server starten
- `npm run lint` - ESLint ausführen

## 📝 Lizenz

**Proprietär**

Dieses Repository ist **privat** und nur für interne Nutzung bestimmt.

---

**Version**: 0.1.0  
**Letzte Aktualisierung**: Dezember 2024

